/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoEvent;
import com.ibm.hwmca.base.custinfo.CustomerInfoListener;
import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CustomerInfoManager
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XCINMGRT";
    private static final String TRACE_MASKF = "XCINMGRF";
    private static final String TRACE_MASKD = "XCINMGRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "CustInfo-Mgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.base.custinfo.CustomerInfoData";
    private static CustomerInfoManager custInfoMgr = null;
    private Object dataLock = new Object();
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();
    private LinkedList eventQueue = new LinkedList();
    private Object eventQueueLock = new Object();
    private Reporter reporter = null;
    private static final long REPORTER_TIMEOUT = 60000L;

    private CustomerInfoManager() {
        Trace.trace(TRACE_MASKT, "<> CustomerInfoManager()");
    }

    public static synchronized CustomerInfoManager getCustomerInfoManager() {
        Trace.trace(TRACE_MASKT, "-> getCustomerInfoManager()");
        if (custInfoMgr == null) {
            custInfoMgr = new CustomerInfoManager();
        }
        Trace.trace(TRACE_MASKT, "<- getCustomerInfoManager()");
        return custInfoMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomerInfoListener(CustomerInfoListener listener) {
        Trace.trace(TRACE_MASKT, "-> addCustomerInfoListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- addCustomerInfoListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomerInfoListener(CustomerInfoListener listener) {
        Trace.trace(TRACE_MASKT, "-> removeCustomerInfoListener()");
        Object object = this.listenersLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeCustomerInfoListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerInfoData getCustomerInfo() {
        Trace.trace(TRACE_MASKT, "-> getCustomerInfo()");
        CustomerInfoData custInfoData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    custInfoData = (CustomerInfoData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 2066, pe).log();
                    custInfoData = new CustomerInfoData();
                }
            } else {
                custInfoData = new CustomerInfoData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getCustomerInfo()");
        return custInfoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomerInfo(CustomerInfoData data) {
        Trace.trace(TRACE_MASKT, "-> setCustomerInfo()");
        Date origLastUpdated = data.getLastUpdated();
        Object object = this.dataLock;
        synchronized (object) {
            try {
                data.setLastUpdated(new Date());
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
                CustomerInfoData dataCopy = this.getCustomerInfo();
                Trace.trace(TRACE_MASKF, dataCopy.toString());
                CustomerInfoEvent event = new CustomerInfoEvent(this, 1, dataCopy);
                this.notifyListeners(event);
            }
            catch (PersistenceException pe) {
                new FrameworkLog(classLogInfo, 2066, pe).log();
                data.setLastUpdated(origLastUpdated);
            }
        }
        Trace.trace(TRACE_MASKT, "<- setCustomerInfo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(CustomerInfoEvent event) {
        Trace.trace(TRACE_MASKT, "-> notifyListeners()");
        Object object = this.eventQueueLock;
        synchronized (object) {
            this.eventQueue.add(event);
            if (this.reporter == null) {
                this.reporter = new Reporter(new Date().toString());
                this.reporter.start();
            }
            this.eventQueueLock.notify();
        }
        Trace.trace(TRACE_MASKT, "<- notifyListeners()");
    }

    public static class SaveRestore
    implements CustomizableData {
        public UIInfo getUIInfo() {
            LocalizableText name = new LocalizableText("com.ibm.hwmca.base.custinfo.res.CustomerInfoMsgs", "DATA_NAME");
            LocalizableText caption = new LocalizableText("com.ibm.hwmca.base.custinfo.res.CustomerInfoMsgs", "DATA_CAPTION");
            return new UIInfo(name, caption);
        }

        public Serializable getSaveableData() {
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "-> getSaveableData()");
            CustomerInfoManager infoMgr = CustomerInfoManager.getCustomerInfoManager();
            CustomerInfoData custInfoData = infoMgr.getCustomerInfo();
            Trace.trace(CustomerInfoManager.TRACE_MASKF, custInfoData.toString());
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<- getSaveableData()");
            return custInfoData.getPersistentData();
        }

        public void restoreData(Serializable obj) {
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "-> restoreData()");
            try {
                PersistentData persistentData = (PersistentData)obj;
                CustomerInfoData custInfoData = new CustomerInfoData(persistentData);
                CustomerInfoManager infoMgr = CustomerInfoManager.getCustomerInfoManager();
                infoMgr.setCustomerInfo(custInfoData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<- restoreData()");
        }

        public String getCustomDataKey() {
            return CustomerInfoManager.PERSISTENCE_NAME;
        }
    }

    private class Reporter
    extends Thread {
        String id;
        boolean inactive = false;

        Reporter(String id) {
            super("Customer Info Event Reporter " + id);
            this.id = id;
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<> Reporter " + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "-> Reporter " + this.id + " running");
            while (!this.inactive) {
                CustomerInfoEvent nextEvent = null;
                long waitBegins = System.currentTimeMillis();
                long timeToWait = 60000L;
                Object object = CustomerInfoManager.this.eventQueueLock;
                synchronized (object) {
                    while (CustomerInfoManager.this.eventQueue.size() <= 0 && timeToWait > 0L) {
                        try {
                            CustomerInfoManager.this.eventQueueLock.wait(timeToWait);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        timeToWait = 60000L - (System.currentTimeMillis() - waitBegins);
                    }
                    if (CustomerInfoManager.this.eventQueue.size() > 0) {
                        nextEvent = (CustomerInfoEvent)CustomerInfoManager.this.eventQueue.removeFirst();
                    } else {
                        CustomerInfoManager.this.reporter = null;
                        this.inactive = true;
                    }
                }
                if (nextEvent == null) continue;
                object = CustomerInfoManager.this.listenersLock;
                synchronized (object) {
                    Iterator iterator = CustomerInfoManager.this.listeners.iterator();
                    while (iterator.hasNext()) {
                        CustomerInfoListener listener = (CustomerInfoListener)iterator.next();
                        listener.customerInfoChanged(nextEvent);
                    }
                }
            }
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<- Reporter " + this.id + " ending due to inactivity");
        }
    }
}

